#include <avr/power.h> 
#include "fft.h"					//avr optimized fixpoint fft in assembler

#define FFT_N          256			//Number of Samples
#define FFT_THRESHOLD   17			//Threshold

int16_t databuffer[FFT_N];                      
complex_t bfly[FFT_N];

void setup()
{
  ADMUX = (0<<REFS1) | (1<<REFS0);      			//AVcc as Reference
  ADCSRA = (1<<ADPS2 | 1<<ADPS1 | 0<<ADPS0);		//Set ADC to 250kHz (16.000.000 / 64) -> Prescaler 64 (Atmel Datasheet)
  ADCSRA |= (1<<ADEN); 								//Activate ADC
  
  Serial.begin(250000);								//UART with Baud 250000 8N1
}

void loop() 
{
  while(1){
    for (int i = 0; i < FFT_N; i++){		  //Sample 256 adc values
      databuffer[i] = analogRead(A0);		  //Add to databuffer array
    }
    fft_input_256(databuffer, bfly);    	//fills the complex array with a wave form to prepare butterfly operations. A hamming window is applied at the same time.
    fft_execute_256(bfly);              	//executes the butterfly operations
    fft_output_256(bfly, databuffer);   	//re-orders the results, converts the complex spectrum into scalar spectrum and output it in linear scale.

    uint16_t Max_Value;                   //highest signal in spectrum              
    uint16_t Max_Value_Index;             //fft index highest signal            
    uint16_t velocity;					          //Velocity in kmh
    
    Max_Value_Index = 0;
    Max_Value = 0;

    for(uint16_t i = 2; i < (FFT_N /2); i++) {    //ignore i = 0 and i = 1
      if (databuffer[i] > Max_Value) {            //search for highest Peak
          Max_Value = databuffer[i];              //remember Peak
          Max_Value_Index = i;                    //remember Peak position
        }
    }

    if (Max_Value > FFT_THRESHOLD) {     
      velocity = Max_Value_Index* 1.578125; 	//velocity = Max_Value_Index* 1.578125, Geschwindigkeit in kmh berechnen und auf Ganzzahl runden
      if(velocity > 3){
        Serial.print(velocity);
        Serial.println(" kmh");
        delay(10);						//delay 10ms         
      }    
    }
  }  
}
